% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_findChild.R
\name{findChild}
\alias{findChild}
\title{Find the children}
\usage{
findChild(tree, node = 11, use.alias = FALSE)
}
\arguments{
\item{tree}{A phylo object.}

\item{node}{An internal node. It could be the node number or the node
label.}

\item{use.alias}{A logical value, TRUE or FALSE. The default is FALSE, and
the node label would be used to name the output; otherwise, the alias of
node label would be used to name the output. The alias of node label is
created by adding a prefix \code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
  vector name is the corresponding node label. If a node has no label, it
  would have NA as name when \code{use.alias = FALSE}, and have the alias of
  node label as name when \code{use.alias = TRUE}.
}
\description{
\code{findChild} finds children of an internal node.
}
\examples{
data(tinyTree)

library(ggtree)
ggtree(tinyTree) +
geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7) +
geom_hilight(node = 17, fill = 'steelblue', alpha = 0.5) +
geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7)

(tips <- findChild(tree = tinyTree, node = 17))

}
\author{
Ruizhu Huang
}
