% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackWidget.R
\name{TnT-shiny}
\alias{TnT-shiny}
\alias{TnTOutput}
\alias{renderTnT}
\title{Shiny bindings for TnT}
\usage{
TnTOutput(outputId, width = "100\%", height = "auto")

renderTnT(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a TnTBoard/TnTGenome object.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the converted
    htmlwidget within Shiny applications.
}
\description{
Output and render functions for using TnT within Shiny
applications and interactive Rmd documents.
}
\examples{
library(shiny)

ui <- fluidPage(fluidRow(
    column(width = 2, {
        "A Simple Example Here"
    }),
    column(width = 10, {
        TnTOutput("out")
    })
))
server <- function (input, output) {
    re.btrack <- reactive({
        gr <- GRanges("chr12", IRanges(100, 1000))
        BlockTrack(gr)
    })
    output$out <- renderTnT({
        TnTBoard(re.btrack())
    })
}
\dontrun{
shinyApp(ui = ui, server = server)
}
}
