% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difftest.R
\name{difftest}
\alias{difftest}
\title{difftest}
\usage{
difftest(data, TSCANorder, df = 3)
}
\arguments{
\item{data}{The raw single_cell data, which is a numeric matrix or data.frame. Rows represent genes/features and columns represent single cells.}

\item{TSCANorder}{The TSCAN ordering generated by function \code{\link{TSCANorder}}.}

\item{df}{Numeric value specifying the degree of freedom used in the GAM model.}
}
\value{
Data frame containing pvalues and qvalues of testing differentially expression.
}
\description{
testing differentially expressed genes
}
\details{
This function tests whether a gene is significantly expressed given pseudotime ordering. Likelihood ratio test is performed to compare a generalized additive model (GAM) with a constant fit to get the p-values. The p-values are adjusted for multiple testing by fdr.
}
\examples{
data(lpsdata)
procdata <- preprocess(lpsdata)
lpsorder <- TSCANorder(exprmclust(procdata))
diffval <- difftest(procdata,lpsorder)
#Selected differentially expressed genes under qvlue cutoff of 0.05
row.names(diffval)[diffval$qval < 0.05]
}
\author{
Zhicheng Ji, Hongkai Ji <zji4@zji4.edu>
}
