% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{run_boltzmann}
\alias{run_boltzmann}
\title{Run Boltzmann Modeling}
\usage{
run_boltzmann(norm_data)
}
\arguments{
\item{norm_data}{data frame input, preferably normalized using
\code{\link{normalize}}.}
}
\value{
data frame containing gam model fitted values
}
\description{
Function runs function \code{model_boltzmann()} and raises warning when
    modeling generates error or warnings.
}
\examples{
data("qPCR_data1")
A01 <- subset(qPCR_data1, Well.Position == "A01")
A01 <- normalize(A01)
run_boltzmann(A01)

}
\seealso{
Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_fit}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{screen}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
