% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaleTSA.R
\name{normalize_fluorescence}
\alias{normalize_fluorescence}
\title{Normalize Fluorescence Curve}
\usage{
normalize_fluorescence(tsa_data = tsa_data, by = "rescale", control_vect = NA)
}
\arguments{
\item{tsa_data}{a data frame that is unmerged and generated by
 TSAR::read_raw_data() or a merged TSA data frame generated by
 TSAR::merge_TSA(). Data frames require a column named "Fluorescence"
containing numeric values for normalizing.}

\item{by}{character string; either c("rescale", "min", "max", "control").
\code{by = "rescale"} by default, scaling Fluorescence values in-between
the minimum and maximum observation. Each well can be
normalized to either the minimum or maximum value with
\code{by = "min"} or \code{by = "max"}, respectively. To normalize
all values to a numeric value or vector, set \code{by = "control"}.}

\item{control_vect}{numeric vector to normalize the column "Fluorescence"
to. An individual number will normalize all measurements to be normalized
to it. The vector will need to align with tsa_data$Fluorescence. Ensure
\code{by = "control"}, else the supplied vector will be ignored.}
}
\value{
a data frame identical to the tsa_data input with a new column
    named "RFU" containing the normalized values
}
\description{
This function will take the TSA data and normalize the arbitrary fluorescence
    measurements based on the specified method. Each well, determined by a
    unique well ID, is normalized independently.
    All measurements can be normalized to the minimum or maximum value.
    Alternatively, setting  \code{by = "rescale"} (the default) will cause
    all values to be normalized between the minimum and
    maximum values, with the maximum  = 1 and the minimum = 0 and all other
    values normalized in-between. Finally, the user can supply a single
    value or vector of values to normalize the data to. The returned data
    frame will be the input tsa data frame with a new column named "RFU"
    containing the normalized TSA data.
}
\examples{
# examples not ran without example dataset
# raw_data <- read_raw_data(raw_data_path)
# normalize_fluorescence(raw_data, by == "control)

}
\seealso{
\code{\link{read_raw_data}} and  \code{\link{merge_TSA}}
    for loading data.

Other TSAR Formatting: 
\code{\link{TSA_Tms}()},
\code{\link{TSA_average}()},
\code{\link{Tm_difference}()},
\code{\link{merge_TSA}()},
\code{\link{merge_norm}()},
\code{\link{rescale}()}
}
\concept{TSAR Formatting}
