% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_well_info.R
\name{join_well_info}
\alias{join_well_info}
\title{Well information input function}
\usage{
join_well_info(
  file_path,
  file = NULL,
  analysis_file,
  skips = 0,
  nrows = 96,
  type
)
}
\arguments{
\item{file_path}{string; file path to read in the file}

\item{file}{object; use file to override the need of file_path if
information is already read in}

\item{analysis_file}{data frame; data frame containing smoothed fluorescence
data and tm values}

\item{skips}{integer; number indicating the number of headers present in
input file, default set to 0 when file input is "by_well"
If the input follows the excel template, this parameter does not apply.}

\item{nrows}{integer; number indicating the number of rows the data is.
Default set to 96 assuming analysis on 96 well plate. Parameter is only
applicable when file input is "by_well". If inputting by excel
template, this parameter does not apply, please ignore.}

\item{type}{string; variable specifies the type of input read in.
type = "by_well" requires input of csv or txt files of three variables:
Well, Protein, Ligand.
type = "by_template" requires input of excel file following the template
format provided}
}
\value{
outputs data frame joining data information with well information
}
\description{
Reads in the ligand and protein information and joins them accordingly
    to the big data frame for graphing purposes.
}
\examples{
data("qPCR_data1")
result <- gam_analysis(qPCR_data1, smoothed = TRUE, fluo = 5)
data("well_information")
join_well_info(
    file_path = NULL, file = well_information,
    read_tsar(result, output_content = 2), type = "by_template"
)

}
\seealso{
Other read_write_analysis: 
\code{\link{read_tsar}()},
\code{\link{write_tsar}()}
}
\concept{read_write_analysis}
