% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{oncoprint.cbio}
\alias{oncoprint.cbio}
\title{oncoprint.cbio}
\usage{
oncoprint.cbio(
  x,
  file = "oncoprint-cbio.txt",
  hom.del = "Homozygous Loss",
  het.loss = "Heterozygous Loss",
  gain = "Low-level Gain",
  amp = "High-level Gain"
)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{file}{name of the file where to save the output}

\item{hom.del}{type of Homozygous Deletion}

\item{het.loss}{type of Heterozygous Loss}

\item{gain}{type of Gain}

\item{amp}{type of Amplification}
}
\value{
A file containing instruction for the CBio visualization Tool
}
\description{
export input for cbio visualization at http://www.cbioportal.org/public-portal/oncoprinter.jsp
}
\examples{
data(crc_gistic)
gistic = import.GISTIC(crc_gistic)
oncoprint.cbio(gistic)

}
