% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrTidyUpESets.R
\name{tpptrTidyUpESets}
\alias{tpptrTidyUpESets}
\title{Tidy up expressionSets}
\usage{
tpptrTidyUpESets(tppESetList, returnType = "exprs")
}
\arguments{
\item{tppESetList}{A list of expressionSets, returned 
by most TPP-TR functions.}

\item{returnType}{A string with two possible values: "exprs", "featureData".}
}
\value{
Either the fold changes per protein across all experiments 
(if \code{returnType = "exprs"}), or the 
additional annotation per protein and experiment (if \code{returnType = "featureData"}). For example, the
peptide counts per identified protein can be found here.
}
\description{
Convert list of expressionSets (intermediate output of several 
TPP-TR functions) to tidy tables.
}
\details{
expressionSet lists are for example produced by 
\code{\link{tpptrImport}}, \code{\link{tpptrNormalize}}, 
\code{\link{tpptrCurveFit}}.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable = hdacTR_config, data = hdacTR_data)
concentrations <- tpptrTidyUpESets(tpptrData)
additionalInfos <- tpptrTidyUpESets(tpptrData, returnType = "featureData")
summary(concentrations)
}
