% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrCurveFit.R
\name{tpptrCurveFit}
\alias{tpptrCurveFit}
\title{Fit melting curves to all proteins in a dataset.}
\usage{
tpptrCurveFit(
  data,
  dataCI = NULL,
  resultPath = NULL,
  ggplotTheme = tppDefaultTheme(),
  doPlot = TRUE,
  startPars = c(Pl = 0, a = 550, b = 10),
  maxAttempts = 500,
  nCores = "max",
  verbose = FALSE
)
}
\arguments{
\item{data}{list of \code{ExpressionSet}s with protein fold changes for curve
fitting.}

\item{dataCI}{list of \code{ExpressionSet}s with protein fold change confidence 
intervals for curve fitting. Default to NULL.}

\item{resultPath}{location where to store the melting curve plots.}

\item{ggplotTheme}{ggplot theme for melting curve plots.}

\item{doPlot}{boolean value indicating whether melting curves should be
plotted, or whether just the curve parameters should be returned.}

\item{startPars}{start values for the melting curve parameters. Will be
passed to function \code{\link{nls}} for curve fitting.}

\item{maxAttempts}{maximal number of curve fitting attempts if model does not
converge.}

\item{nCores}{either a numerical value given the desired number of CPUs, or
'max' to automatically assign the maximum possible number (default).}

\item{verbose}{plot name of each fitted protein to the command lin as a means
of progress report.}
}
\value{
A list of ExpressionSets storing the data together with the melting
  curve parameters for each experiment.
  Each ExpressionSet contains the measured fold changes, as well as row and
  column metadata. In each ExpressionSet \code{S}, the fold changes can be
  accessed by \code{Biobase::exprs(S)}. Protein expNames can be accessed by 
  \code{featureNames(S)}. Isobaric labels and the corresponding temperatures are 
  returned by \code{S$label} and \code{S$temperature}.
}
\description{
Fit melting curves to all proteins in a dataset.
}
\details{
If the melting curve fitting procedure does not converge, it will be
  repeatedly started from perturbed starting parameters (maximum iterations 
  defined by argument \code{maxAttempts})
  
  If \code{doPlot = TRUE}, melting curves are be plotted in individual files
  per protein. Each file is named by its unique identifier. Filenames are
  truncated to 255 characters (requirement by most operation systems). 
  Truncated filenames are indicated by the suffix "_truncated[d]", where [d] 
  is a unique number to avoid redundancies.

The melting curve plots will be stored in a subfolder with name 
  \code{Melting_Curves} at the location specified by \code{resultPath}.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable=hdacTR_config, data=hdacTR_data)
tpptrNorm <- tpptrNormalize(data=tpptrData, normReqs=tpptrDefaultNormReqs())
normalizedData <- tpptrNorm$normData
hdacSubsets <- lapply(normalizedData, 
                      function(d) d[grepl("HDAC", Biobase::featureNames(d))])
tpptrFittedHDACs <- tpptrCurveFit(hdacSubsets, nCores=1)
# Show estimated parameters for vehicle and treatment experiments:
Biobase::pData(Biobase::featureData(tpptrFittedHDACs[["Vehicle_1"]]))
Biobase::pData(Biobase::featureData(tpptrFittedHDACs[["Panobinostat_1"]]))

}
\seealso{
\code{\link{tppDefaultTheme}}
}
