% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPOP.R
\name{pairwise_col_diff}
\alias{pairwise_col_diff}
\title{Compute pairwise difference between matrix columns}
\usage{
pairwise_col_diff(x)
}
\arguments{
\item{x}{A data matrix of size n times p. Where rows are observations and
columns are features.}
}
\value{
A matrix of size n times (p choose 2), where each column is the
difference between two of the original columns.
}
\description{
Compute pairwise difference between matrix columns
}
\examples{
n <- 1
p <- 4
x <- matrix(rep(seq_len(p), n), nrow = n, ncol = p, byrow = TRUE)
colnames(x) <- paste0("X", seq_len(p))
pairwise_col_diff(x)
}
