% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{plot_silhouette}
\alias{plot_silhouette}
\title{Generates a silhouette plot for a given clustering configuration.}
\usage{
plot_silhouette(TMixClust_object, sim_metric = "euclidean",
  sil_color = "#bdbdbd")
}
\arguments{
\item{TMixClust_object}{list object created by the \code{TMixClust}
function (see function \code{TMixClust})}

\item{sim_metric}{character string taking one of the possible values:
"euclidean", "gower" or "manhattan". Default is "euclidean".}

\item{sil_color}{color of the bars representing the silhouette widths
on the plot}
}
\value{
List object with the following components:
\itemize{
\item \code{similarity_m} similarity matrix
\item \code{silh} silhouette object
}

Renders a plot comprised of a set of barplots with the distributions of
silhouette
coefficients for the data points in each cluster. Each barplot has indicated
on its right hand side the total number of points in the corresponding
cluster.
The plot also indicates with a dotted line,
the overall average silhouette width,
whose value is specified at the bottom of the plot.
}
\description{
\code{plot_silhouette}
}
\examples{
# Load the TMixClust object associated to the toy time series data
# provided with the TMixClust package
data(best_clust_toy_obj)

# Plot the silhouette for the clustering stored in the toy TMixClust object
plot_silhouette(best_clust_toy_obj)

}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
