% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidenceToList.R
\name{incidenceToList}
\alias{incidenceToList}
\title{Convert Incidence Matrix to a Named List of Sets}
\usage{
incidenceToList(incidence)
}
\arguments{
\item{incidence}{incidence matrix with set names as rows and elements as
columns. For instance, the output of \code{\link{sparseIncidence}}.}
}
\value{
a named list of sets with the same length as \code{nrow(incidence)}.
}
\description{
Converts an incidence matrix to a named list of sets. The
inverse of \code{\link{sparseIncidence}}.
}
\note{
Currently, there are no checks to ensure \code{incidence} is a valid
incidence matrix.
}
\examples{
x <- list("A" = c("a", "b", "c"),
          "B" = c("c", "d"),
          "C" = c("x", "y", "z", "z"), # duplicates
          "D" = c("a", NA)) # missing values

(imat <- sparseIncidence(x)) # incidence matrix

incidenceToList(incidence = imat)
}
