% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genepi.R
\name{topTraitsOfTargets}
\alias{topTraitsOfTargets}
\title{Use MSigDB TF targets resource to find targets of input TF and find traits to which these targets have been mapped}
\usage{
topTraitsOfTargets(TFsym, gsc, gwcat, ntraits = 6, force = FALSE, ...)
}
\arguments{
\item{TFsym}{character(1) symbol for a TF must be present in \code{tftCollMap[, "hgnc.heur"]}}

\item{gsc}{an instance of \code{\link[GSEABase]{GeneSetCollection-class}}, intended to enumerate
targets of a single transcription factor in each GeneSet, as in TFutils::tftColl}

\item{gwcat}{instance of \code{\link[gwascat]{gwaswloc-class}}}

\item{ntraits}{numeric(1) number of traits to report}

\item{force}{logical see note, set to true if you want to skip mapping from TFsym to a specific motif or TF identifier used as name of a GeneSet in gsc}

\item{\dots}{character() vector of fields in mcols(gwcat) to include}
}
\value{
data.frame
symbol, set force = TRUE to use a known 'motif' name among \code{names(gsc)}
}
\description{
Use MSigDB TF targets resource to find targets of input TF and find traits to which these targets have been mapped
}
\note{
If \code{tftCollMap[, "hgnc.heur"]} does not possess the necessary
}
\examples{
suppressPackageStartupMessages({
library(GSEABase)
})  # more results if you substitute ebicat37 from gwascat below
topTraitsOfTargets("MTF1" , tftColl, gwascat_hg19_chr17)
}
