% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFCatalog-class.R
\name{TFCatalog}
\alias{TFCatalog}
\title{Constructor for TFCatalog}
\usage{
TFCatalog(name, nativeIds, HGNCmap, metadata)
}
\arguments{
\item{name}{informative character(1) for collection}

\item{nativeIds}{character() vector of identifiers used by collection creators}

\item{HGNCmap}{data.frame with column 1 nativeIds, column 2 HGNC or hgnc.heur for MSigDb
and any other columns of use}

\item{metadata}{a list of metadata elements}
}
\value{
instance of TFCatalog
}
\description{
Constructor for TFCatalog
}
\examples{
if (require("GSEABase")) {
 TFs_MSIG = TFCatalog(name="MsigDb.TFT",nativeIds=names(TFutils::tftColl),
 HGNCmap=data.frame(TFutils::tftCollMap,stringAsFactors=FALSE))
 TFs_MSIG
}
}
