% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{GSEA_run}
\alias{GSEA_run}
\title{Function to run a GSEA analysis}
\usage{
GSEA_run(
  gene.list,
  LFC,
  chip_index = get_chip_index(),
  get.RES = FALSE,
  RES.filter = NULL,
  perms = 1000
)
}
\arguments{
\item{gene.list}{List of Entrez IDs ordered by their fold change.}

\item{LFC}{Vector of log2(Fold Change) values.}

\item{chip_index}{Data frame containing accession IDs of ChIPs and the 
tested TFs.
If not provided, the entire internal database will be used.}

\item{get.RES}{(Optional) boolean. If TRUE, stores Running Enrichment 
Scores for selected TFs.}

\item{RES.filter}{(Optional) character vector. When get.RES == TRUE, 
specifies which TF's RES to store.}

\item{perms}{(Optional) integer. Number of permutations for the 
enrichment test.}
}
\value{
A list containing:
- Enrichment.table: Data frame with enrichment scores and p-values for 
each ChIP-Seq experiment.
- RES (optional): List of running sums for each ChIP-Seq.
- indicators (optional): List of binary vectors indicating matches between
the gene list and gene sets.
}
\description{
Analyzes the distribution of TFBS across a sorted list 
of genes.
}
\examples{
data('hypoxia', package = 'TFEA.ChIP')
hypoxia <- preprocessInputData(hypoxia)
chip_index <- get_chip_index(TFfilter = c('HIF1A', 'EPAS1', 'ARNT'))
GSEA.result <- GSEA_run(hypoxia$Genes, hypoxia$log2FoldChange, chip_index,
get.RES = TRUE)
}
