% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxTSV-class.R
\docType{class}
\name{TENxTSV-class}
\alias{TENxTSV-class}
\alias{.TENxTSV}
\alias{TENxTSV}
\alias{import,TENxTSV,ANY,ANY-method}
\alias{metadata,TENxTSV-method}
\title{TENxTSV: A class to represent 10x tab separated values files}
\usage{
\S4method{import}{TENxTSV,ANY,ANY}(con, format, text, ...)

TENxTSV(resource, compressed = FALSE, ...)

\S4method{metadata}{TENxTSV}(x, ...)
}
\arguments{
\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{...}{Parameters to pass to the format-specific method.}

\item{resource}{character(1) The path to the file}

\item{compressed}{logical(1) Whether the resource file is compressed (default
FALSE)}

\item{x}{A \code{TENxTSV} object}
}
\value{
A \code{TENxTSV} class object; a \code{tibble} for the import method
}
\description{
This class is general purpose for reading in tabular data from
the 10x Genomics website with the \code{.tsv} file extension. The class also
supports compressed files, i.e., those with the \code{.tsv.gz} extension.
}
\details{
Typical \code{.tsv} files obtained from the 10X website are compressed
and contain information relevant to 'barcodes' and 'features'. Currently,
the code only supports files such as \verb{features.tsv.*} and \verb{barcodes.tsv.*}.
}
\section{Functions}{
\itemize{
\item \code{import(con = TENxTSV, format = ANY, text = ANY)}: General import method for \code{tsv} files from 10x;
using \code{readr::read_tsv} and returning a \code{tibble} representation

\item \code{metadata(TENxTSV)}: \code{metadata} method for \code{TENxTSV} objects

}}
