% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxFragments-class.R
\name{TENxFragments}
\alias{TENxFragments}
\title{TENxFragments: Import fragments files from 10X}
\usage{
TENxFragments(resource, yieldSize = 200, which = GRanges(), ...)
}
\arguments{
\item{resource}{character(1) The file path to the fragments resource, usually
a compressed tabix file with extension \code{.tsv.gz}.}

\item{yieldSize}{numeric() The number of records to read by default, 200
records will be imported. A warning will be emitted if not modified.}

\item{which}{GRanges() A GRanges indicating the regions of interest. This
get sent to \code{RSamtools} as the \code{param} input.}

\item{...}{Further arguments to the class generator function (currently not
used)}
}
\value{
A \code{RaggedExperiment} object class
}
\description{
TENxFragments: Import fragments files from 10X
}
\examples{

fr <- system.file(
    "extdata", "pbmc_3k_atac_ex_fragments.tsv.gz",
    package = "TENxIO", mustWork = TRUE
)

tfr <- TENxFragments(fr)

fra <- import(tfr)

}
