% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatureTransRect.R
\name{selectFeatureTransRect}
\alias{selectFeatureTransRect}
\title{Select features for a tensor generated from two matrices that
 share samples.}
\usage{
selectFeatureTransRect(
  HOSVD,
  cond,
  de = rep(1e-04, 2),
  p0 = 0.01,
  breaks = 100L,
  input_all = NULL
)
}
\arguments{
\item{HOSVD}{HOSVD}

\item{cond}{list of conditions}

\item{de}{initial values for optimization of standard deviation}

\item{p0}{threshold value for the significance}

\item{breaks}{number of bins of the histogram of P-values}

\item{input_all}{The selected singular value vectors attributed to samples.
if NULL, interactive mode}
}
\value{
list of logical vector that represent if the individual features
are selected and P-values.
}
\description{
Select features for a tensor generated from two matrices that
 share samples.
}
\examples{
library(TDbasedUFE)
set.seed(0)
matrix1 <- matrix(runif(1000),20) #row features, column samples
matrix2 <- matrix(runif(2000),40) #row features, column samples
Z <- prepareTensorfromMatrix(t(matrix1),t(matrix2))
Z <- prepareTensorRect(sample=as.character(seq_len(50)),
feature=list(as.character(seq_len(20)),as.character(seq_len(40))),
sampleData=list(rep(seq_len(2),each=25)),value=Z)
HOSVD <- computeHosvd(Z)
cond <- list(attr(Z,"sampleData")[[1]],NULL,NULL)
index_all <- selectFeatureTransRect(HOSVD,cond,de=c(0.1,0.1),
input_all=2,p0=1e-10)
}
