\name{hypoData_mg}
\docType{data}
\alias{hypoData_mg}
\title{A simulation dataset for comparing three-group tag count
 data, focusing on RNA-seq}
\description{
A simulation dataset, consisting of 1,000 rows (or genes) and
 9 columns (or independent biological samples)
}
\usage{data(hypoData_mg)}
\format{\code{hypoData_mg} is a matrix of dimension 1,000 times 9.}
\details{
The \code{hypoData_mg}, a matrix object, is a simulation dataset which 
consists of 1,000 rows (genes) and 9 columns (samples).
Each cell of matrix indicates the number of counts to the gene in the sample.
The first three columns are produced from biological replicates of,
for example, Group 1, the next three columns are from Group2 and the
remaining columns are from Group 3;
i.e., {G1_rep1, G1_rep2, G1_rep3} vs. {G2_rep1, G2_rep2, G2_rep3} vs.
{G3_rep1, G3_rep2, G3_rep3}.
This data is generated by the \code{\link{simulateReadCounts}}
function with the following parameters (see Examples). 
The first 200 genes are differentially expressed among
the three groups. Of these, the first 140
genes are expressed at a higher level only in Group 1 (G1), the next
40 genes are expressed at a higher level only in G2 and the last 
20 genes are expressed at a higher level only in G3. Accordingly, the
201-1000th genes are not differentially expressed (non-DEGs).
The levels of differential expression (DE) are four-fold in each group. 
} 
\examples{
# The 'hypoData_mg' is generated by following commands.
tcc <- simulateReadCounts(Ngene = 1000, PDEG = 0.2,
                          DEG.assign = c(0.7, 0.2, 0.1),
                          DEG.foldchange = c(4, 4, 4),
                          replicates = c(3, 3, 3))
hypoData_mg <- tcc$count
}
\keyword{datasets}
