% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regioned_dna_Class.R
\name{get_rscu}
\alias{get_rscu}
\alias{get_rscu,regioned_dna-method}
\alias{get_rscu,DNAStringSet-method}
\title{Get Relative Synonymous Codon Usage (rscu) of synonymous codons}
\usage{
get_rscu(object, numcode = 1, ...)

\S4method{get_rscu}{regioned_dna}(object, numcode)

\S4method{get_rscu}{DNAStringSet}(object, numcode)
}
\arguments{
\item{object}{regioned_dna / DNAStringSet / codon usage matrix (vector)}

\item{numcode}{The ncbi genetic code number for translation. Default value: \code{1}. Details please refer to \code{?seqinr::translate} ("https://rdrr.io/cran/seqinr/man/translate.html").}

\item{...}{...}
}
\value{
matrix
}
\description{
Access the Relative Synonymous Codon Usage rscu
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_rscu(rgd.seq)
}
\seealso{
\code{\link{input_seq}}, \code{\link{get_region}},
  \code{\link{get_cu}}, \code{\link{get_du}}, \code{\link{get_freq}}
}
