% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2symbol.R
\name{convert2symbol}
\alias{convert2symbol}
\title{Convert identifier to gene symbol}
\usage{
convert2symbol(df, id = "UNIPROT")
}
\arguments{
\item{df}{data.frame; fractionated proteomics data where
data contains 10 columns of duplicated 5 fractionations and
rownames must be identifier e.g. UNIPROT, Entrez ID}

\item{id}{caharacter; identifier id for each protein}
}
\value{
df
}
\description{
Identifier for each feature should be converted
into gene symbols unless they are not gene symbols
}
\examples{
{

df <- data.frame(Uniprot = c("A4D0S4","A8TX70","O00305","O00337"),
Organism = rep("Homo Sap.", 4))

rownames(df) <- df$Uniprot
}

}
