% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statial.R
\name{getMarkerMeans}
\alias{getMarkerMeans}
\title{Extract the average expression for all markers for each cell type in each
region defined by lisaClust}
\usage{
getMarkerMeans(
  data,
  imageID = NULL,
  cellType = NULL,
  region = NULL,
  markers = NULL,
  assay = 1,
  replaceVal = 0
)
}
\arguments{
\item{data}{A SingleCellExperiment object with intensities data in the assays slot and
regions information in colData generated by lisaClust.}

\item{imageID}{The colData column that stores the image IDs.}

\item{cellType}{The colData column that store the cell types.}

\item{region}{The colData column that stores the regions.}

\item{markers}{A string vector of markers that proxy a cell's state. If NULL, all markers
will be used.}

\item{assay}{Which assay do you want to use for the expression data.}

\item{replaceVal}{A value to replace missing values with.}
}
\description{
Takes a SingleCellExperiment and outputs a dataframe in a convenient format for
cross validation
}
\examples{
data(kerenSCE)

kerenSCE <- kerenSCE[, kerenSCE$imageID \%in\% c("5", "6")]

regionSCE <- lisaClust::lisaClust(kerenSCE, k = 5)

lisaClustOutput <- getMarkerMeans(regionSCE)
}
