% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{splineDV}
\alias{splineDV}
\title{Spline-DV}
\usage{
splineDV(
  X,
  Y,
  ncounts = 1000,
  ncells = 15,
  spar = 0.5,
  mtPerc = 15,
  detailed = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{X}{Count matrix or SingleCellExperiment (Test sample)}

\item{Y}{Count matrix or SingleCellExperiment (Control sample)}

\item{ncounts}{An integer value. Defines the minimum reads required for a cell to be included in the analysis.}

\item{ncells}{An integer value. Defines the minimum cells required for a gene to be included in the analysis.}

\item{spar}{A double value. Smoothing parameter for Spline.}

\item{mtPerc}{A double value. Defines the minimum percent mitochondrial genes expression required for a cell to be excluded from the analysis.}

\item{detailed}{A boolean value. Defines whether to add individual splineHVG DataFrame to the output.}

\item{verbose}{A Boolean value (TRUE/FALSE), if TRUE, prints messages.}
}
\value{
A DataFrame with DV Statistics. The statistics include log1p(mean), log1p(CV), dropout rates, nearest point on spline (splinex, spliney and splinez) and distance from spline for each sample. The distance across conditions is stored in "vectorDist". P values are computed assuming normal distribution of distance differences.
}
\description{
Differential Variability (DV) analysis. 3 gene statistics are used - Mean, CV and Dropout rate of each gene. A smooth.spline is modeled using these statistics. First, the distance vectors of each gene from spline is computed using the splineHVG function for each condition. Then the vector distance between the distance vectors are computed. A high
}
\examples{
# example code
## Generate example count data
X <- abs(matrix(round(rpois(2000*500, lambda=0.5), 0), nrow=2000, ncol=500))
rownames(X) <- paste0('g', as.character(1:2000))
Y <- abs(matrix(round(rpois(2000*500, lambda=0.5), 0), nrow=2000, ncol=500))
rownames(Y) <- paste0('g', as.character(1:2000))

## Run splineDV
res <- splineDV(X, Y)
}
\author{
Shreyan Gupta <xenon8778@tamu.edu>
}
