% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSamples.R
\name{removeSample}
\alias{removeSample}
\title{Remove sample(s) from SpatialOverlay}
\usage{
removeSample(overlay, remove)
}
\arguments{
\item{overlay}{SpatialOverlay object}

\item{remove}{sampNames of overlay to remove}
}
\value{
SpatialOverlay object without samples in remove
}
\description{
Remove sample(s) from SpatialOverlay
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

muBrainLW <- system.file("extdata", "muBrain_LabWorksheet.txt", 
                         package = "SpatialOmicsOverlay")

muBrainLW <- readLabWorksheet(muBrainLW, slideName = "D5761 (3)")

samps <- muBrainLW$Sample_ID[muBrainLW$segment != "Full ROI"]

muBrainSub <- removeSample(overlay = muBrain, remove = samps)

muBrain
muBrainSub

}
