% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageManipulation.R
\name{changeImageColoring}
\alias{changeImageColoring}
\title{Update color scheme for changing to RGB image}
\usage{
changeImageColoring(overlay, color, dye)
}
\arguments{
\item{overlay}{SpatialOverlay object, with 4channel image}

\item{color}{color to change dye to, hex or color name}

\item{dye}{which dye to change color, can be from Dye or DisplayName column 
from fluor(overlay)}
}
\value{
SpatialOverlay object with updated fluor data
}
\description{
Update color scheme for changing to RGB image
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

muBrain <- add4ChannelImage(overlay = muBrain, 
                            ometiff = downloadMouseBrainImage(), res = 8)

fluor(muBrain)

muBrain <- changeImageColoring(overlay = muBrain, color = "magenta", 
                               dye = "Cy5")
muBrain <- changeImageColoring(overlay = muBrain, color = "#42f5ef", 
                               dye = "Alexa 488")

fluor(muBrain)

}
