% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addParquetPaths.R
\name{addParquetPathsCosmx}
\alias{addParquetPathsCosmx}
\title{Add CosMx-related parquet paths to metadata for transcripts, polygon, or cell/nucleus boundaries.}
\usage{
addParquetPathsCosmx(
  sxe,
  dirName,
  addTx = TRUE,
  txMetaNames = "transcripts",
  txPattern = "tx_file.csv",
  addPolygon = TRUE,
  polygonMetaNames = "polygons",
  polygonPattern = "polygons.csv"
)
}
\arguments{
\item{sxe}{a SPE or SCE Xenium object to add parquet to \code{metadata(sxe)}.}

\item{dirName}{the directory that stores the transcripts/polygon
.csv or .parquet files.}

\item{addTx}{to add path to transcripts parquet to \code{metadata(sxe)}or not.
Default is TRUE.}

\item{txMetaNames}{names to add to slots in \code{metadata(sxe)[["name"]]}.
The number of \code{txMetaNames} should equal to number of file detected in \code{dirName}
with \code{txPattern}. Can have multiple, such as \code{c("transcripts", "transcripts1")}.
Default is \code{"transcripts"}.}

\item{txPattern}{.csv or .parquet (if you have previous converted) pattern
of transcript file in \code{dirName}. Can have multiple, such as \code{c("tx_file.csv", "tx_file1.csv")}.
Default value is \code{"tx_file.csv"}.}

\item{addPolygon}{to add path to polygons parquet to \code{metadata(sxe)} or not.
Default is TRUE.}

\item{polygonMetaNames}{names to add to slots in \verb{metadata(sxe)$}. The number of
\code{polygonMetaNames} should equal to number of file detected in \code{dirName} with \code{polygonPattern}.
Can have multiple. Can have multiple, such as \code{c("polygons", "polygons1")}.
Default is \code{"transcripts"}.}

\item{polygonPattern}{.csv or .parquet (if you have previous converted) pattern
of polygons file in the \code{dirName}. Can have multiple, such as \code{c("polygons.csv", "polygons1.csv")}.
Default value is \code{"polygons.csv"}.}
}
\value{
a SPE or SCE Xenium object with parquet paths added to metadata
}
\description{
Add CosMx-related parquet paths to metadata for transcripts, polygon, or cell/nucleus boundaries.
}
\examples{
cospath <- system.file(file.path("extdata", "CosMx_small"), 
                       package = "SpatialExperimentIO")

sxe <- readCosmxSXE(dirName = cospath, addParquetPaths = FALSE)
sxe <- addParquetPathsCosmx(sxe, dirName = cospath, addPolygon = FALSE)

}
\author{
Yixing Estella Dong
}
