% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIL_barplot.R
\name{TIL_barplot}
\alias{TIL_barplot}
\title{Barplot of abundance estimates}
\usage{
TIL_barplot(mat, draw_legend = FALSE, main = "", col = NULL, ...)
}
\arguments{
\item{mat}{Matrix of cell proportions or abundances, in the same dimensions
output by spatialdecon
 (cells in rows, observations in columns). User is free to re-order
 columns/observations in
 whatever order is best for display.}

\item{draw_legend}{Logical. If TRUE, the function draws a legend in a new
plot frame.}

\item{main}{Title for barplot}

\item{col}{Vector of colors for cell types. Defaults to pre-set colors for
the safeTME cell types.}

\item{...}{Arguments passed to barplot()}
}
\value{
Draws a barplot.
}
\description{
Draw barplot of the "betas" from a decon fit
}
\examples{
data(mini_geomx_dataset)
data(safeTME)
# estimate background:
mini_geomx_dataset$bg <- derive_GeoMx_background(
  norm = mini_geomx_dataset$normalized,
  probepool = rep(1, nrow(mini_geomx_dataset$normalized)),
  negnames = "NegProbe"
)
# run basic decon:
res0 <- spatialdecon(
  norm = mini_geomx_dataset$normalized,
  bg = mini_geomx_dataset$bg,
  X = safeTME
)
# run barplot:
TIL_barplot(mat = res0$beta)
# run barplot and draw a color legend
TIL_barplot(mat = res0$beta, draw_legend = TRUE)
}
