% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotPolygons}
\alias{plotPolygons}
\title{plotPolygons}
\usage{
plotPolygons(
  spe,
  colourBy = "darkgrey",
  colourLog = FALSE,
  polyColumn = "polygons.global",
  sampleId = unique(spe$sample_id),
  bgColor = "white",
  fillAlpha = 1,
  palette = NULL,
  borderCol = NA,
  borderAlpha = 1,
  borderLineWidth = 0.1,
  drawBorders = TRUE
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with polygon data as an `sf` object.}

\item{colourBy}{A column in `colData(spe)` for coloring the polygons or a
string color in colors(). (Default is "darkgrey")}

\item{colourLog}{Logical to log-transform the data to enhance visualization
(Default is FALSE).}

\item{polyColumn}{character for the name of the column where the polygons sf
are stored (default is "polygons.global")}

\item{sampleId}{Sample ID for plot title. Default is the unique sample ID.}

\item{bgColor}{character indicating color for the background
(default is "white")}

\item{fillAlpha}{Transparency level for polygon fill. Default is `1`.}

\item{palette}{Colors to use if `colourBy` is a factor. Default is `NULL`.}

\item{borderCol}{Color of polygon borders. Default is `"black"`.}

\item{borderAlpha}{Transparency level for borders. Default is `1`.}

\item{borderLineWidth}{Width of polygon borders. Default is `0.1`.}

\item{drawBorders}{Logical; whether to draw borders. Default is `TRUE`.}
}
\value{
A `ggplot` object representing the polygon plot of the spatial data.
}
\description{
Plot polygons from a `SpatialExperiment` object using ggplot2.
}
\examples{
example(readAndAddPolygonsToSPE)
plotPolygons(spe, colourBy="Mean.DAPI")
}
