% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeOutliersQCScore}
\alias{computeOutliersQCScore}
\title{computeOutliersQCScore}
\usage{
computeOutliersQCScore(
  spe,
  metricList = c("log2CountArea", "Area_um", "log2AspectRatio", "log2Ctrl_total_ratio")
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial omics data.}

\item{metricList}{A character vector specifying the metrics to include in
the QC score formula. Default is `c("log2CountArea", "Area_um",
"log2AspectRatio", "log2Ctrl_total_ratio")`.}
}
\value{
The `SpatialExperiment` object with added outlier variables in
`colData` and the temporary QCScore metric variables that in the
`metadata`.
}
\description{
Compute outlier cells for each metric that can be used in QC score formula
for SpatialExperiment.

This function calculates outlier cells for each variable specified
in `metricList` for a `SpatialExperiment`. Log2CountArea must be present in
the `colData` of the `SpatialExperiment` object as a minimum requirement.
The user can choose which metrics to include among the following: Area_um,
log2Ctrl_total_ratio, log2AspectRatio. For Xenium and Merfish datasets,
log2AspectRatio is automatically removed from the formula.
}
\details{
The function computes outliers for each specified metric after
automatically choosing the appropriate method according to the skewness of
the distribution.
Internally the function:
\enumerate{
   \item Calls \code{.checkSkw()} to choose the proper outlier detection
    method according to the variable skewness,
   \item Calls \code{computeSpatialOutlier()} on each included metric to get
   fences,
   \item Labels cells as “LOW”/“HIGH” outliers or “NO”
}
}
\examples{
example(readCosmxSPE)
spe <- spatialPerCellQC(spe)
spe <- computeOutliersQCScore(spe)
table(spe$log2CountArea_outlier_train)
}
