% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotCellsFovs}
\alias{plotCellsFovs}
\title{plotCellsFovs}
\usage{
plotCellsFovs(
  spe,
  sampleId = unique(spe$sample_id),
  pointCol = "firebrick",
  numbersCol = "black",
  alphaNumbers = 0.8,
  fovDim = metadata(spe)$fov_dim
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with `fov` in `colData`.}

\item{sampleId}{Character string identifying which sample to plot.
Default: `unique(spe$sample_id)`.}

\item{pointCol}{Color for the cell centroids. Default: `"firebrick"`.}

\item{numbersCol}{Color for the FoV labels. Default: `"black"`.}

\item{alphaNumbers}{Numeric transparency for FoV labels. Default: `0.8`.}

\item{fovDim}{numeric with two named dimensions xdim, ydim. (Default is
metadata(spe)$fov_dim)}
}
\value{
A `ggplot` object showing cell centroids and FoV boundaries.
}
\description{
Plot cell centroids in FoVs
Creates a scatter plot with cell centroids arranged in their FoVs as an
overlapping grid.
}
\examples{
example(readCosmxSPE)
g <- plotCellsFovs(spe)
print(g)
}
