% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{clusterEnrich}
\alias{clusterEnrich}
\title{Perform Cluster Enrichment Analysis}
\usage{
clusterEnrich(
  clusterTab,
  se,
  inputSet,
  reference = NULL,
  ptm = FALSE,
  adj = "BH",
  filterP = 0.05,
  ifFDR = FALSE
)
}
\arguments{
\item{clusterTab}{A \code{data frame} containing cluster information, where
each row corresponds to a gene and its assigned cluster.}

\item{se}{A \code{SummarizedExperiment} object containing gene expression
data and metadata.}

\item{inputSet}{A \code{list} or \code{data frame} of gene sets to be used
for enrichment analysis.}

\item{reference}{A \code{character} vector of reference genes. If NULL, it
will be extracted from se object. Default is \code{NULL}.}

\item{ptm}{\code{Logical}. If \code{TRUE}, the function will perform
enrichment analysis on post-translational modification (PTM) gene sets.
Default is \code{FALSE}.}

\item{adj}{\code{Character}. The method for adjusting p-values. Default is
"BH".}

\item{filterP}{\code{Numeric}. The p-value threshold for filtering
significant results. Default is 0.05.}

\item{ifFDR}{\code{Logical}. If \code{TRUE}, the function will use
FDR-adjusted p-values for significance filtering. Default is \code{FALSE}.}
}
\value{
A \code{list} containing two elements:
\itemize{
  \item `table`: A \code{data frame} with enrichment results for each
  cluster and pathway.
  \item `plot`: A \code{ggplot2} object showing the significance of
  enrichment for each pathway across clusters.
}
}
\description{
\code{clusterEnrich} performs enrichment analysis on gene clusters, using
Fisher's Exact Test to determine the significance of enrichment for each
cluster.
}
\details{
The function first retrieves or computes the reference set of genes or PTM
sites. It then performs enrichment analysis for each cluster using the
\code{runFisher} function.
The results are filtered based on the p-value threshold and adjusted for
multiple testing if \code{ifFDR} is \code{TRUE}. The function generates a
dot plot where the size and color of the points represent the significance
of enrichment.
}
\examples{
library(SummarizedExperiment)
# Load multiAssayExperiment object
data("dia_example")
# Get SummarizedExperiment object
se <- dia_example[["Phosphoproteome"]]
colData(se) <- colData(dia_example)
seProcess <- preprocessPhos(seData = se, normalize = TRUE, impute = "QRILC")
result <- addZeroTime(seProcess, condition = "treatment", treat = "EGF",
zeroTreat = "1stCrtl", timeRange = c("20min","40min", "6h"))
# Get the numeric matrix
exprMat <- SummarizedExperiment::assay(result)
# Call the clustering function
clust <- clusterTS(x = exprMat, k = 3)
genesetPath <- appDir <- system.file("shiny-app/geneset",
package = "SmartPhos")
inGMT <- piano::loadGSC(paste0(genesetPath,
"/Cancer_Hallmark.gmt"),type="gmt")
# Call the function
clusterEnrich(clust$cluster, seProcess, inGMT)

}
