% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{SortReadsBySingleTF}
\alias{SortReadsBySingleTF}
\title{Wrapper to SortReads for single TF case}
\usage{
SortReadsBySingleTF(
  MethSM,
  TFBS,
  bins = list(c(-35, -25), c(-15, 15), c(25, 35)),
  coverage = 20
)
}
\arguments{
\item{MethSM}{Single molecule matrix list as returned by CallContextMethylation}

\item{TFBS}{Transcription factor binding site to use for sorting, passed as a GRanges object of length 1}

\item{bins}{list of 3 relative bin coordinates. Defaults to list(c(-35,-25), c(-15,15), c(25,35)).
bins[[1]] represents the upstream bin, with coordinates relative to the start of the TFBS.
bins[[2]] represents the TFBS bin, with coordinates relative to the center of the TFBS.
bins[[3]] represents the downstream bin, with coordinates relative to the end of the TFBS.}

\item{coverage}{integer. Minimum number of reads covering all sorting bins for sorting to be performed. Defaults to 20}
}
\value{
List of reads sorted by single TF
}
\description{
Wrapper to SortReads for single TF case
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_3.qs", 
package="SingleMoleculeFootprinting"))

SortedReads = SortReadsBySingleTF(MethSM = Methylation[[2]], TFBS = TFBSs)

}
