% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencing_QCs.r
\name{BaitCapture}
\alias{BaitCapture}
\title{Bait capture efficiency}
\usage{
BaitCapture(sampleFile, genome, baits, clObj = NULL)
}
\arguments{
\item{sampleFile}{QuasR sample sheet}

\item{genome}{BS genome}

\item{baits}{GRanges obj of bait coordinates. We provide and example through SingleMoleculeFootprintingData::EnrichmentRegions_mm10.rds()}

\item{clObj}{cluster object to emply for parallel processing created using the parallel::makeCluster function. Defaults to NULL}
}
\value{
bait capture efficiency
}
\description{
check bait capture efficiency. Expected to be ~70% for mouse genome
}
\examples{

sampleFile = paste0(tempdir(), "/NRF1Pair_Qinput.txt")

if(file.exists(sampleFile)){
library(BSgenome.Mmusculus.UCSC.mm10)
BaitRegions = SingleMoleculeFootprintingData::EnrichmentRegions_mm10.rds()
BaitCapture(sampleFile = sampleFile, genome = BSgenome.Mmusculus.UCSC.mm10, baits = BaitRegions)
}

}
