% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_sce}
\alias{simulate_sce}
\alias{simulate_independent_cells}
\alias{simulate_branched_random_walk}
\title{Simulate SingleCellExperiment Datasets with Independent or Branched Gene Expression Patterns}
\usage{
simulate_independent_cells(
  cell_size = NULL,
  gene_size = NULL,
  N_cell = NULL,
  N_gene = NULL,
  ltq_var_rate = 0.5
)

simulate_branched_random_walk(
  cell_size = NULL,
  gene_size = NULL,
  N_gene = NULL,
  ltq_var_rate = 0.5,
  N_path = 149L,
  length_path = 13L
)
}
\arguments{
\item{cell_size}{Optional vector of real or simulated total UMI counts per cell.
If \code{NULL}, defaults to values from the \emph{Baron et al.} study.}

\item{gene_size}{Optional vector of real or simulated total UMI counts per gene.
If \code{NULL}, defaults to values from the \emph{Baron et al.} study.}

\item{N_cell}{Integer. Number of cells to simulate.
(For \code{simulate_branched_random_walk} is equal to \code{N_path * length_path}).
If \code{NULL} inferred from \code{cell_size}.}

\item{N_gene}{Integer. Number of genes to simulate. If \code{NULL}, inferred from \code{gene_size}.}

\item{ltq_var_rate}{Rate parameter for the exponential distribution used to
simulate per-gene variance (default: \code{0.5}).}

\item{N_path}{(Only for \code{simulate_branched_random_walk}) Number of branching paths (default: \code{149}).}

\item{length_path}{(Only for \code{simulate_branched_random_walk}) Number of steps (cells) per path (default: \code{13}).}
}
\value{
A \code{SingleCellExperiment} object containing:
\itemize{
\item \code{assays$counts}: Simulated UMI count matrix.
\item \code{assays$logFC}: Simulated log fold-changes for each gene-cell pair.
\item \code{rowData}: Gene-level metadata including \code{ltq_mean} and \code{ltq_var}.
\item \code{colData}: Cell-level metadata including \code{predecessor} for \code{simulated_branched_random_walk}.
}
}
\description{
These functions generate synthetic single-cell RNA-seq datasets based the
methods described in original Sanity publication for benchmarking.
}
\details{
\itemize{
\item \code{simulate_independent_cells}: gene expression values are generated
independently for each cell. This results in uncorrelated expression patterns
across the dataset.
\item \code{simulate_branched_random_walk}: cells follow a \strong{branched random walk}
through gene expression space, producing correlated gene expression patterns
that reflect pseudo-temporal differentiation trajectories.
}
}
\examples{
# Simulate dataset with independent gene expression
sce_indep <- simulate_independent_cells(N_cell = 100, N_gene = 50)

# Simulate dataset with a branched random walk trajectory
sce_branch <- simulate_branched_random_walk(N_path = 20, length_path = 5, N_gene = 50)

}
\references{
A Single-Cell Transcriptomic Map of the Human and Mouse Pancreas Reveals Inter- and Intra-cell Population Structure
Baron, Maayan et al. \emph{Cell Systems}, Volume 3, Issue 4, 346 - 360.e4 \url{https://doi.org/10.1016/j.cels.2016.08.011}
}
