% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-cluster.assign.R
\name{cluster.assign}
\alias{cluster.assign}
\alias{cluster.assign,SingleCellExperiment-method}
\alias{cluster.assign,SingleCellExperiment}
\alias{cluster.assign,SVPExperiment-method}
\alias{cluster.assign,SVPExperiment}
\title{clusting and assign the label for each feature(specify the gene sets).}
\usage{
cluster.assign(
  data,
  assay.type = "affi.score",
  assign = FALSE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{cluster.assign}{SingleCellExperiment}(
  data,
  assay.type = "affi.score",
  assign = FALSE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{cluster.assign}{SVPExperiment}(
  data,
  assay.type = "affi.score",
  assign = FALSE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)
}
\arguments{
\item{data}{A \linkS4class{SVPExperiment}, which has run \code{runSGSA} or \code{detect.svp}, or
a \linkS4class{SingleCellExperiment} which was extracted from \linkS4class{SVPExperiment} using
\code{gsvaExp} function.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{affi.score}.}

\item{assign}{whether assign the max affinity of gene set or pathway to the each cell, default is FALSE.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{...}{dot parameters}
}
\value{
if input is a \linkS4class{SVPExperiment}, output will be also a \linkS4class{SVPExperiment}, and the result assay
was stored in assay of the specified \code{gsvaexp}, which is a \linkS4class{SingleCellExperiment}. If input is a
\linkS4class{SingleCellExperiment} (which is extracted from \linkS4class{SVPExperiment} using \code{gsvaExp()} function),
output will be a \linkS4class{SingleCellExperiment}, the result can be extracted using \code{assay()} function.
}
\description{
clusting and assign the label for each feature(specify the gene sets).
}
\details{
when use \code{runSGSA} to calculated the gene set activity of cell, if \code{assign = TRUE} we will assign the max affinity of
gene set or pathway to the each cell. If \code{assign = FALSE}, the max affinity of gene set or pathway will be kept.
}
\examples{
library(SpatialExperiment)
# This example data was extracted from the
# result of runSGSA with gsvaExp function.
data(hpda_spe_cell_dec)
assays(hpda_spe_cell_dec)
hpda_spe_cell_dec <- hpda_spe_cell_dec |>
   cluster.assign()
hpda_spe_cell_dec 
}
\seealso{
to calculate the activity score of gene sets or pathway: \code{\link{runSGSA}}.
}
