% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-transcription-rates-class.R
\name{stericHindrance}
\alias{stericHindrance}
\title{Accessor for steric hindrance flag}
\usage{
stericHindrance(object)
}
\arguments{
\item{object}{A TranscriptionRates object}
}
\value{
A logical value indicating whether steric hindrance was modeled
}
\description{
Generic accessor for the steric hindrance flag from any TranscriptionRates
object
}
\examples{
# Create an ExperimentTranscriptionRates object
load(system.file("extdata", "granges_for_read_counting_DLD1_chr21.RData",
package = "STADyUM"))
expRates <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control",
    stericHindrance = TRUE,
    omegaScale = 1000
)
stericHindrance(expRates)

}
