% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcription_rates_lrt-class.R
\docType{class}
\name{TranscriptionRatesLRT-class}
\alias{TranscriptionRatesLRT-class}
\alias{likelihoodRatioTest}
\alias{transcriptionRates1}
\alias{transcriptionRates1,TranscriptionRatesLRT-method}
\alias{transcriptionRates2}
\alias{transcriptionRates2,TranscriptionRatesLRT-method}
\alias{spikeInFile}
\alias{spikeInFile,TranscriptionRatesLRT-method}
\alias{chiTbl}
\alias{chiTbl,TranscriptionRatesLRT-method}
\alias{betaTbl}
\alias{betaTbl,TranscriptionRatesLRT-method}
\alias{plotPauseSiteContourMapTwoConditions}
\alias{plotPauseSiteContourMapTwoConditions,TranscriptionRatesLRT-method}
\alias{BetaViolinPlot}
\alias{BetaViolinPlot,TranscriptionRatesLRT-method}
\alias{ChiViolinPlot}
\alias{ChiViolinPlot,TranscriptionRatesLRT-method}
\alias{plotLfcMa}
\alias{plotLfcMa,TranscriptionRatesLRT-method}
\title{Constructor for TranscriptionRatesLRT object}
\usage{
likelihoodRatioTest(
  transcriptionRates1,
  transcriptionRates2,
  scaleFactor = 1,
  spikeInFile = NULL
)

transcriptionRates1(object)

\S4method{transcriptionRates1}{TranscriptionRatesLRT}(object)

transcriptionRates2(object)

\S4method{transcriptionRates2}{TranscriptionRatesLRT}(object)

spikeInFile(object)

\S4method{spikeInFile}{TranscriptionRatesLRT}(object)

chiTbl(object)

\S4method{chiTbl}{TranscriptionRatesLRT}(object)

betaTbl(object)

\S4method{betaTbl}{TranscriptionRatesLRT}(object)

plotPauseSiteContourMapTwoConditions(
  object,
  file = NULL,
  width = 8,
  height = 6,
  dpi = 300
)

\S4method{plotPauseSiteContourMapTwoConditions}{TranscriptionRatesLRT}(
  object,
  file = NULL,
  width = 8,
  height = 6,
  dpi = 300
)

BetaViolinPlot(object, file = NULL, width = 8, height = 6, dpi = 300)

\S4method{BetaViolinPlot}{TranscriptionRatesLRT}(object, file = NULL, width = 8, height = 6, dpi = 300)

ChiViolinPlot(object, file = NULL, width = 8, height = 6, dpi = 300)

\S4method{ChiViolinPlot}{TranscriptionRatesLRT}(object, file = NULL, width = 8, height = 6, dpi = 300)

plotLfcMa(object, file = NULL, width = 8, height = 6, dpi = 300)

\S4method{plotLfcMa}{TranscriptionRatesLRT}(object, file = NULL, width = 8, height = 6, dpi = 300)
}
\arguments{
\item{transcriptionRates1}{an \code{\linkS4class{TranscriptionRates}} object}

\item{transcriptionRates2}{an \code{\linkS4class{TranscriptionRates}} object}

\item{scaleFactor}{a numeric value to scale the beta estimates. Defaults to 1}

\item{spikeInFile}{path to a csv file containing scale factors
based on total or spike-in reads or NULL if not provided. Defaults to NULL.}

\item{object}{an \code{\linkS4class{TranscriptionRatesLRT}} object}

\item{file}{the path to a file to save the plot to}

\item{width}{the width of the plot in inches}

\item{height}{the height of the plot in inches}

\item{dpi}{the resolution of the plot in dpi}
}
\value{
a \code{\linkS4class{TranscriptionRatesLRT}} object

tbl_df

tbl_df

an \code{\link{ggplot2}} object

an \code{\link{ggplot2}} object

an \code{\link{ggplot2}} object

an \code{\link{ggplot2}} object
}
\description{
Constructs results of likelihood ratio test comparing transcription data
estimated from two different sets of experimental read counts.

Likelihood ratio test comparing aspects of transcriptional
dynamics of the same TU under different conditions using Likelihood Ratio
Test Statistics. Uses read counts and rate estimates estimated from
estimateTranscriptionRates. The method also requires
scaling factors to determine changes in \eqn{\chi} estimates. They can be the numbers
of total mapped reads or spike-in reads from the samples. Likelihood ratio
test computes the log 2 fold change in \eqn{\chi} estimates between conditions, the
log 2 fold change in beta estimates between conditions, the t-statistics for
the likelihood ratio tests, and the adjusted p-values based on the "BH"
method.

Accessor for the first ExperimentTranscriptionRates object from a
TranscriptionRatesLRT object.

Accessor for the second ExperimentTranscriptionRates object from a
TranscriptionRatesLRT object.

Accessor for the spike-in scaling factor from a
TranscriptionRatesLRT object.

Accessor for the chi table from a TranscriptionRatesLRT object.

Accessor for the beta table from a TranscriptionRatesLRT object.

Plot a contour map with mean pause site position on the x-axis and pause site
standard deviation on the y-axis. The plot is a comparison between two
conditions.

Plot a violin plot comparing the beta values between two conditions.

Plot a violin plot comparing the chi values between two conditions.

Plot a MA plot for log fold change treated/control vs log mean beta*zeta.
}
\examples{
load(system.file("extdata", "granges_for_read_counting_DLD1_chr21.RData",
package = "STADyUM"))
transcriptionRates1 <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control"
)
transcriptionRates2 <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Treated"
)
spikeInFile <- system.file("extdata", "spikein_scaling_factor.csv", 
package = "STADyUM")
lrts <- likelihoodRatioTest(transcriptionRates1, transcriptionRates2,
scaleFactor=1, spikeInFile)
# Print the likelihood ratio test object
print(lrts)
# Create an ExperimentTranscriptionRates object
load(system.file("extdata", "granges_for_read_counting_DLD1_chr21.RData",
package = "STADyUM"))
transcriptionRates1 <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control"
)
transcriptionRates2 <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Treated"
)
spikeInFile <- system.file("extdata", "spikein_scaling_factor.csv", 
package = "STADyUM")
lrts <- likelihoodRatioTest(transcriptionRates1, transcriptionRates2,
scaleFactor=1, spikeInFile)
plotPauseSiteContourMapTwoConditions(lrts,
file="pause_sites_contour_map.png")

}
