% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialScatterpie.R
\name{plotSpatialScatterpie}
\alias{plotSpatialScatterpie}
\title{Spatial scatterpie}
\usage{
plotSpatialScatterpie(
  x,
  y,
  cell_types = colnames(y),
  img = FALSE,
  slice = NULL,
  scatterpie_alpha = 1,
  pie_scale = 0.4,
  degrees = NULL,
  axis = NULL,
  ...
)
}
\arguments{
\item{x}{Object containing the spots coordinates, it can be an object of class
SpatialExperiment, dataframe or matrix. For the latter two
rownames should have the spot barcodes to match x. If a matrix it has to
of dimensions nrow(y) x 2 where the columns are the x and y coordinates
in that order.}

\item{y}{Matrix or dataframe containing the deconvoluted spots. rownames
need to be the spot barcodes to match to x.}

\item{cell_types}{Vector of cell type names to plot. By default uses the
column names of y.}

\item{img}{Logical TRUE or FALSE indicating whether to plot the image or not.
Objects of classes accepted by \code{plotImage} can also be passed and
that image will be used. By default FALSE.}

\item{slice}{Character string indicating which slice to plot if img is TRUE.
By default uses the first image.}

\item{scatterpie_alpha}{Numeric scalar to set the alpha of the pie charts.
By default 1.}

\item{pie_scale}{Numeric scalar to set the size of the pie charts.
By default 0.4.}

\item{degrees}{From SpatialExperiment rotateImg. For clockwise (degrees > 0)
and counter-clockwise (degrees < 0) rotation. By default NULL.}

\item{axis}{From SpatialExperiment mirrorImg. When a SpatialExperiment object
is passed as the image return the mirror image. For horizontal (axis = "h")
 and vertical (axis = "v") mirroring. By default NULL.}

\item{...}{additional parameters to geom_scatterpie}
}
\value{
\code{ggplot} object
}
\description{
This function takes in the coordinates of the spots and the
  proportions of the cell types within each spot. It returns a plot where
  each spot is a piechart showing proportions of the cell type composition.
}
\examples{
set.seed(321)

# Coordinates
x <- replicate(2, rnorm(100))
rownames(x) <- paste0("spot", seq_len(nrow(x)))
colnames(x) <- c("imagecol", "imagerow")

# Proportions
y <- replicate(m <- 5, runif(nrow(x), 0, 1))
y <- prop.table(y, 1)

rownames(y) <- paste0("spot", seq_len(nrow(y)))
colnames(y) <- paste0("type", seq_len(ncol(y)))

(plt <- plotSpatialScatterpie(x = x, y = y))
}
\author{
Marc Elosua Bayes & Helena L Crowell
}
