% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{makeROI}
\alias{makeROI}
\title{makeROI}
\usage{
makeROI(df, type = "SE")
}
\arguments{
\item{df}{data.frame object from \code{\link{extractSpliceEvents}}}

\item{type}{type of splicing event c("SE","RI","MXE","A5SS","A3SS")}
}
\value{
a list containing\cr
  (1) type : splice type\cr
  (2) name : ID of transcript\cr
  (3) roi  : GRanges object of splice site\cr
  (4) flank : GRanges object of flanking exons of splice site\cr
  (5) roi_range : GRangesList of splice site and it's alternative outcome based on \code{type}
}
\description{
Creates an object to store information about the splice site (region of interest)
including flanking regions and alternative splice outcome
}
\examples{
single_record<-splice_data$data[which(grepl("Prmt5",splice_data$data$Symbol)),]
roi <- makeROI(single_record,type="SE")
}
\author{
Diana Low
}
