% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance_to_tumour_margin.R
\name{calculate_distance_to_margin}
\alias{calculate_distance_to_margin}
\title{calculate the distances of each cell to the margin}
\usage{
calculate_distance_to_margin(spe_object)
}
\arguments{
\item{spe_object}{SpatialExperiment object. It should contain information of
the detected bordering cells (`colData()` has `Region` column).}
}
\value{
An spe_object with a `Distance.To.Border` column is returned.
}
\description{
Returns a SPE object with the minimum distance from cells of
  interest (CoI) to the identified bordering cells.
}
\examples{
spe_border <- identify_bordering_cells(SPIAT::defined_image,
reference_cell = "Tumour", feature_colname = "Cell.Type", n_to_exclude = 10)
spe_dist <- calculate_distance_to_margin(spe_border)
}
