% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{renameBins}
\alias{renameBins}
\title{Rename bins.}
\usage{
renameBins(SNPhood.o, newBinsMapping, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{newBinsMapping}{Named list. For clarity of mapping, the names of the list must be the currently defined bin names, 
and the values of each element the corresponding new ones.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with the requested bins being renamed.
}
\description{
\code{renameBins} renames bins from a \emph{SNPhood} object.
}
\examples{
data(SNPhood.o, package="SNPhood")
mapping = list("Bin1_NEW")
names(mapping) = annotationBins(SNPhood.o)[1]
SNPhood_mod.o = renameBins(SNPhood.o, mapping)
}
\seealso{
\code{\link{deleteDatasets}}, \code{\link{deleteRegions}}
}

