% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotFDRResults}
\alias{plotFDRResults}
\title{Graphically summarize the results of the allelic bias analysis for a specific dataset and region.}
\usage{
plotFDRResults(SNPhood.o, dataset, FDRThreshold = NULL, fileToPlot = NULL,
  printPlot = TRUE, returnOnlyPlotNotObject = FALSE, verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{dataset}{Numeric(1) or Character(1). Single dataset that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or its annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}).}

\item{FDRThreshold}{Numeric(1) or NULL. Default NULL. If set to a value between 0 and 1, a horizontal line will be drawn in the FDR summary plot
to indicate at which p-value threshold the FDR reaches the user-defined value. Additionally, the maximum p-value threshold from the FDR summary
data will be printed for which thr FDR is below the specified threshold.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{printPlot}{Logical(1). Default TRUE. Should the plots be printed? Only relevant if \code{fileToPlot} is set to NULL; otherwise, the plots
are always printed to the output file.}

\item{returnOnlyPlotNotObject}{Logical(1). Default FALSE. If set to TRUE, only the plots are returned but not the actual object. 
Otherwise, for consistancy among the various visualization functions, the \code{\linkS4class{SNPhood}}  object is always returned, while the plots are
either written to a PDF file as specified by the parameter \code{fileToPlot} and/or to the currently active graphics device (i.e., the console usually)}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
the generated \pkg{ggplot2} plot(s) as list for further processing. May contain multiple plots, depending on the function. The plot(s) can then be plotted individually or modified arbitrarily as the user wants. For example, if multiple plots are returned and the plots have been saved in a variable called plots.l, simply type plots.l[[1]] to view the first plot.
}
\description{
\code{plotAllelicBiasResults} graphically summarizes the results of the allelic bias analysis for a specific dataset and region.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood.o = testForAllelicBiases(SNPhood.o, readGroups = c("maternal", "paternal"))
# Plot FDR results for first dataset
plotFDRResults(SNPhood.o, annotationDatasets(SNPhood.o)[1], FDRThreshold = NULL, fileToPlot = NULL)

# Plot FDR results for second dataset, save in file and also detemrine p-value treshold for which the FDR is below 10\%
plotFDRResults(SNPhood.o, annotationDatasets(SNPhood.o)[1], FDRThreshold = 0.1, fileToPlot = "FDR_summary.pdf")

}

