% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotAndCalculateWeakAndStrongGenotype}
\alias{plotAndCalculateWeakAndStrongGenotype}
\title{Visualizes and calculates strong and weak genotypes.}
\usage{
plotAndCalculateWeakAndStrongGenotype(SNPhood.o, normalize = TRUE,
  nClustersVec = 3, fileToPlot = NULL, verbose = FALSE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{normalize}{Logical(1). Default TRUE. Should a normalization be done on the counts/enrichments values before clustering? If set to TRUE,
a normalization procedure based on subtracting the mean dividing by standard deviation for each region is performed. For more details, see the
vignette.}

\item{nClustersVec}{Numeric. Default 2. The number of clusters the data should be divided into. This can either be a vector or a single value. if multiple clusters are specified, multiple clustering analyses will be performed and for each of them, a plot is produced. make sure to specify the parameter fileToPlot in that case; otherwise, only the last plot may be visible.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
Modified \code{\linkS4class{SNPhood}} object with the results of the analysis stored in the object. 
Specifically, a matrix for average reads per SNP for datasets which have strong and weak genotypes, respectively, are stored in the
slot additionalResults$genotype. 
The SNPs which have invariant genotypes across all the samples being analyzed are also saved. 
In addition, clustering on the strong and weak genotype read mateices are reportd as in the function \code{\link{plotAndClusterMatrix}}.
}
\description{
The function \code{plotAndCalculateWeakAndStrongGenotype} finds the strongest and weakest genotypes based on reads extracted around each region. Strong and weak genotypes are found using the reads extracted from SNPhood and their corresponding genotypes as found by the function \code{associateGenotypes}
Note the reads have to be merged using the function \code{mergeReadGroups} before running this function.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood_merged.o = mergeReadGroups(SNPhood.o)
SNPhood_merged.o = plotAndCalculateWeakAndStrongGenotype(SNPhood_merged.o, nClustersVec = 6)
SNPhood_merged.o = plotAndCalculateWeakAndStrongGenotype(SNPhood_merged.o, nClustersVec = 2:6, verbose = FALSE)
}

