% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{mergeReadGroups}
\alias{mergeReadGroups}
\title{Merges the counts of all read groups for a \emph{SNPhood} object}
\usage{
mergeReadGroups(SNPhood.o, summaryFunction = "sum", verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{summaryFunction}{Character(1). Default "sum". Either "sum" or "mean". How should the read counts from different read groups be summarized. 
If set to "sum", all counts are summed up, which yields values that are identical as running the main analysis non-allele-specifically. 
If set to "mean", the mean value across all read groups is calculated.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
A modified \code{\linkS4class{SNPhood}} object with only one read group "allReadGroups", with all occurences of
the original read groups replaced by "allReadGroups". For object consistency, as mentioned in the warning below, 
some results from analyses depending on read groups are removed completely.
}
\description{
\code{mergeReadGroups} merges the counts of all read groups for a \code{\linkS4class{SNPhood}} object. This function can only be executed if more than one read group is defined in the object and
if read counts have not been converted into allelic fractions. Also carefully note the warning below.
}
\section{Warning}{
 
\strong{Merging read groups is irreversible. This transformation cannot be undone.} 
It might therefore be advisable to save the resulting object in a new variable as shown in the examples.

\strong{Results from the allelic bias test and clustering results will also be removed to keep the object consistent.}
}
\examples{
data(SNPhood.o, package="SNPhood")
nReadGroups(SNPhood.o)
SNPhood_merged.o = mergeReadGroups(SNPhood.o)
nReadGroups(SNPhood.o)
}

