% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSpliceGraph}
\alias{plotSpliceGraph}
\title{Plot splice graph}
\usage{
plotSpliceGraph(x, geneID = NULL, geneName = NULL, eventID = NULL,
  which = NULL, toscale = c("exon", "none", "gene"), label = c("id",
  "name", "label", "none"), color = "gray", color_novel = color,
  color_alpha = 0.8, color_labels = FALSE, border = "fill",
  curvature = NULL, ypos = c(0.5, 0.1), score = NULL,
  score_color = "darkblue", score_ylim = NULL, score_ypos = c(0.3, 0.1),
  score_nbin = 200, score_summary = mean, score_label = NULL,
  ranges = NULL, ranges_color = "darkblue", ranges_ypos = c(0.1, 0.1),
  main = NULL, tx_view = FALSE, tx_dist = 0.2, short_output = TRUE)
}
\arguments{
\item{x}{\code{SGFeatures} or \code{SGVariants} object}

\item{geneID}{Single gene identifier used to subset \code{x}}

\item{geneName}{Single gene name used to subset \code{x}}

\item{eventID}{Single event identifier used to subset \code{x}}

\item{which}{\code{GRanges} used to subset \code{x}}

\item{toscale}{Controls which parts of the splice graph are drawn to
scale. Possible values are \dQuote{none} (exonic and intronic regions
have constant length), \dQuote{exon} (exonic regions are drawn to scale)
and \dQuote{gene} (both exonic and intronic regions are drawn to scale).}

\item{label}{Format of exon/splice junction labels,
possible values are \dQuote{id} (format E1,... J1,...), \dQuote{name}
(format type:chromosome:start-end:strand), \dQuote{label} for labels
specified in metadata column \dQuote{label}, or \dQuote{none}
for no labels.}

\item{color}{Color used for plotting the splice graph. Ignored if features
metadata column \dQuote{color} is not \code{NULL}.}

\item{color_novel}{Features with missing annotation are
highlighted in \code{color_novel}. Ignored if features
metadata column \dQuote{color} is not \code{NULL}.}

\item{color_alpha}{Controls color transparency}

\item{color_labels}{Logical indicating whether label colors should
be the same as feature colors}

\item{border}{Determines the color of exon borders, can be \dQuote{fill}
(same as exon color), \dQuote{none} (no border), or a valid color name}

\item{curvature}{Numeric determining curvature of plotted splice junctions.}

\item{ypos}{Numeric vector of length two, indicating the vertical
position and height of the exon bins in the splice graph,
specificed as fraction of the height of the plotting region
(not supported for \code{tx_view = TRUE})}

\item{score}{\code{RLeList} containing nucleotide-level scores
to be plotted with the splice graph}

\item{score_color}{Color used for plotting scores}

\item{score_ylim}{Numeric vector of length two, determining y-axis range
for plotting scores}

\item{score_ypos}{Numeric vector of length two, indicating the vertical
position and height of the score panel, specificed as fraction of the
height of the plotting region}

\item{score_nbin}{Number of bins for plotting scores}

\item{score_summary}{Function used to calculate per-bin score summaries}

\item{score_label}{Label used to annotate score panel}

\item{ranges}{\code{GRangesList} to be plotted with the splice graph}

\item{ranges_color}{Color used for plotting ranges}

\item{ranges_ypos}{Numeric vector of length two, indicating the vertical
position and height of the ranges panel, specificed as fraction of the
height of the plotting region}

\item{main}{Plot title}

\item{tx_view}{Plot transcripts instead of splice graph (experimental)}

\item{tx_dist}{Vertical distance between transcripts as fraction of height
of plotting region}

\item{short_output}{Logical indicating whether the returned data frame
should only include information that is likely useful to the user}
}
\value{
\code{data.frame} with information on exon bins and
  splice junctions included in the splice graph
}
\description{
Plot the splice graph implied by splice junctions and exon bins.
Invisibly returns a \code{data.frame} with details of plotted
features, including genomic coordinates.
}
\details{
By default, the color of features in the splice graph is
determined by annotation status (see arguments \code{color},
\code{color_novel}) and feature labels are generated automatically
(see argument \code{label}). Alternatively, colors and labels can
be specified via metadata columns \dQuote{color} and
\dQuote{label}, respectively.
}
\examples{
\dontrun{
sgf_annotated <- annotate(sgf_pred, txf_ann)
plotSpliceGraph(sgf_annotated)
}
\dontrun{
sgv_annotated <- annotate(sgv_pred, txf_ann)
plotSpliceGraph(sgv_annotated)
}
NULL
}
\author{
Leonard Goldstein
}
