% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{importTranscripts}
\alias{importTranscripts}
\title{Import transcripts from GFF file}
\usage{
importTranscripts(file, tag_tx = "transcript_id", tag_gene = "gene_id")
}
\arguments{
\item{file}{Character string specifying input GFF file}

\item{tag_tx}{GFF attribute tag for transcript identifier}

\item{tag_gene}{GFF attribute tag for gene identifier}
}
\value{
\code{GRangesList} of exons grouped by transcipts with
  metadata columns txName, geneName, cdsStart, cdsEnd.
}
\description{
Import GFF file and generate a \code{GRangesList} of transcripts
suitable as input for functions \code{convertToTxFeatures} or
\code{predictVariantEffects}.
}
\examples{
\dontrun{
tx <- importTranscripts(file)
}
NULL
}
\author{
Leonard Goldstein
}
