% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadataUtils.R
\name{setaMetadata}
\alias{setaMetadata}
\title{Extract Sample-Level Metadata from Various Objects}
\usage{
setaMetadata(x, sample_col = "Sample ID", meta_cols = NULL)
}
\arguments{
\item{x}{An object of class dataframe which contains cell-level or
sample-level metadata.}

\item{sample_col}{Character. The sample identifier column name in source_obj.
Default is 'sample_id'. This column is used to group the metadata.}

\item{meta_cols}{Character vector. Names of metadata columns to retain.
If NULL, all columns present in the source object are considered.
However, only those columns where all entries are identical within
each sample are included in the final output.}
}
\value{
A dataframe where each row corresponds to a unique sample and each
column represents a metadata variable that has uniform values within samples.
Columns with non-unique values within any sample are
excluded, and a warning lists these columns.
}
\description{
This function extracts sample-level metadata
from a dataframe. It ensures that each metadata column contains
unique values per sample. If a metadata column contains
non-unique values within any sample, that column is excluded from the output,
and the user is notified via a warning. Useful when preparing metadata for
visualizations or analyses where sample-level inspection is required.
}
\examples{
# Using a Seurat object
\donttest{
# if (requireNamespace("SeuratObject", quietly = TRUE)) {
# meta_df <- setaMetadata(seurat_obj[[]],
#                         sample_col="donor_id",
#                         meta_cols=c("disease", "Severity"))
# }
#
# Using a SingleCellExperiment object with default parameters
# if (requireNamespace("SingleCellExperiment", quietly = TRUE)) {
# meta_df <- setaMetadata(data.frame(colData(sce_obj)))
#
# Using a dataframe and extracting all possible metadata columns
# meta_df <- setaMetadata(df)
# }
}
}
