% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaILR}
\alias{setaILR}
\title{Isometric Log-Ratio (ILR) Transform
Applies the ILR transform to an integer counts matrix.
For each sample (row), the data are log-transformed
(with an optional Box Cox like transformation)
then projected onto an orthonormal Helmert basis,
reducing dimensionality by one.}
\usage{
setaILR(counts, boxcox_p = 0, taxTree = NULL, pseudocount = 1)
}
\arguments{
\item{counts}{An integer matrix of celltype counts with samples in rows.}

\item{boxcox_p}{Numeric. If nonzero, a Box Cox type transform
is applied to the log-values. Default is 0 (no Box Cox transformation).}

\item{taxTree}{Unused. Reserved for future taxonomic-balance approaches.}

\item{pseudocount}{Numeric. Added to avoid \code{log(0)}. Default is 1.}
}
\value{
A list with:
\describe{
  \item{method}{A string indicating the ILR transform.
                If \code{boxcox_p} is nonzero,
                the value is indicated in the method string.}
  \item{counts}{A matrix of ILR-transformed values with
                \code{ncol(counts) - 1} columns
                and the same number of rows (samples) as the input.}
}
}
\description{
Isometric Log-Ratio (ILR) Transform
Applies the ILR transform to an integer counts matrix.
For each sample (row), the data are log-transformed
(with an optional Box Cox like transformation)
then projected onto an orthonormal Helmert basis,
reducing dimensionality by one.
}
\details{
The ILR transform is computed as follows:
\enumerate{
  \item Add a pseudocount and take the natural logarithm:
    \deqn{y = \log(x + \text{pseudocount})}
  \item If \code{boxcox_p != 0}, apply the Box Cox like transform:
    \deqn{y = \frac{\exp(p \, y) - 1}{p}}
  \item Project the log-transformed data onto an orthonormal
        Helmert basis computed via QR decomposition.
}
}
\examples{
# Example matrix: rows are samples, columns are cell types.
mat <- matrix(c(1, 2, 4, 8), nrow = 2, byrow = TRUE)
colnames(mat) <- c("A", "B")
# ILR transformation reduces the dimension by 1.
out <- setaILR(mat, boxcox_p = 0, pseudocount = 1)
out$counts
}
\references{
Aitchison, J. (1982). The Statistical Analysis of Compositional Data.
\emph{Journal of the Royal Statistical Society.
      Series B (Methodological)}, 44(2), 139-177.
}
