% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceMethods.R
\name{setaDistances}
\alias{setaDistances}
\title{Compute Distance Matrix between Samples}
\usage{
setaDistances(transformed_counts, method = "euclidean")
}
\arguments{
\item{transformed_counts}{Numeric matrix: rows as samples and columns as taxa
(e.g., output from \code{setaCLR}, \code{setaTransform}, etc.).}

\item{method}{Character. Distance metric for \code{\link[stats]{dist}}.
Default: \code{"euclidean"} See \code{\link[stats]{dist}} for options.}
}
\value{
A long-form \code{data.frame} with three columns:
\describe{
  \item{from}{Sample ID of the first sample in the pairwise comparison.}
  \item{to}{Sample ID of the second sample in the pairwise comparison.}
  \item{distance}{Numeric distance between the two samples.}
}
}
\description{
Calculates a pairwise distance matrix between samples based on user-specified
or default (\code{"euclidean"}) distance metrics. If used on CLR-transformed
data, the default Euclidean distance is the \emph{Aitchison distance},
which is commonly used in compositional data analysis (CoDA).
}
\details{
This function calculates distances \strong{between samples}.

Output is a long-form structure convenient to merge with sample-level
metadata using \code{\link[base]{merge}} or \code{\link[dplyr]{left_join}}.
}
\examples{
# Example CLR transformed data (2 samples, 3 taxa)
mat <- matrix(c(1, 2, 3, 4, 5, 6), nrow = 2, byrow = TRUE)
colnames(mat) <- c("Taxon1", "Taxon2", "Taxon3")
rownames(mat) <- c("SampleA", "SampleB")

clr_mat <- setaCLR(mat, pseudocount = 0)

# Calculate Euclidean (Aitchison) distance
dist_df <- setaDistances(clr_mat)
print(head(dist_df))

}
\references{
Aitchison, J. (1982). The Statistical Analysis of Compositional Data.
\emph{Journal of the Royal Statistical Society. Series B (Methodological)},
44(2), 139-177.
}
