% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data}
\alias{data}
\alias{mockSeurat}
\alias{mockSCE}
\alias{mockLong}
\alias{mockCount}
\alias{makeTypeHierarchy}
\title{Synthetic single-cell, mixture and marker data}
\usage{
mockSeurat(ng = 200, nc = 50, nt = 3, ns = 4, nb = 2)

mockLong(nc = 50, nt = 3, ns = 4, nb = 2, useBatch = TRUE)

mockCount(df = mockLong())

mockSCE(nc = 500, nt = 3, ns = 4, nb = 2, useBatch = TRUE)

makeTypeHierarchy(type_levels)
}
\arguments{
\item{ng, nc, nt, ns, nb}{integer scalar specifying the number
of genes, cells, types (groups), samples, and batches to simulate.}

\item{useBatch}{logical scalar indicating whether to include a batch metadata
column}

\item{df}{data.frame in the format of `mockLong()`.}

\item{type_levels}{character vector of type levels representing cell types to
be assigned to fine, mid and broad annotations}
}
\value{
\itemize{
\item{\code{mockSeurat} returns a \code{Seurat} object
  with rows = genes, columns = single cells, and cell metadata
  column \code{type} containing group identifiers.}
\item{\code{mockLong} returns a \code{data.frame} object
  with rows = cells, columns = cell metadata
  column \code{fine_type}, \code{mid_type}, \code{broad_type}
  containing group identifiers at different hierarchical levels.}
\item{\code{mockCount} returns a \code{data.frame} object
  with rows = type x sample, columns = metadata
  column \code{bc} containing the number of cells per type x sample.}
\item{\code{mockSCE} returns a \code{SingleCellExperiment} object
  with rows = genes, columns = single cells, and cell metadata
  column \code{type} containing group identifiers.}
\item{\code{makeTypeHierarchy} returns a list of as many elements as levels
  in the hierarchy, with names corresponding to the type levels and
  values containing the corresponding type identifiers at that level.}
}
}
\description{
\code{mockSeurat/mockSCE/mockLong} are designed to generate synthetic single-cell
data. These data are not meant to represent biologically
meaningful use-cases, but are solely intended for use in examples, for
unit-testing, and to demonstrate \code{SETA}'s general functionality.
Please don't use it in real life.
}
\examples{
seu <- mockSeurat()
sce <- mockSCE()
hierarchy <- makeTypeHierarchy(c("Lineage", "Type", "State"))
}
